% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_issue_events}
\alias{get_issue_events}
\title{Get events for a specific issue from GitHub repository}
\usage{
get_issue_events(ref, number)
}
\arguments{
\item{ref}{Repository reference (list) created by \code{create_repo_ref()}}

\item{number}{Number of issue}
}
\value{
Content of GET request as list
}
\description{
In addition to information returned by GitHub API, appends field "number" for the issue number
to which the returned events correspond.
}
\examples{
\dontrun{
myrepo <- create_repo_ref('emilyriederer', 'myrepo')
events_res <- get_issue_events(myrepo, number = 1)
events <- parse_issue_events(events_res)
}
}
\seealso{
Other issues: \code{\link{get_issue_comments}},
  \code{\link{get_issues}},
  \code{\link{parse_issue_comments}},
  \code{\link{parse_issue_events}},
  \code{\link{parse_issues}}, \code{\link{post_issue}},
  \code{\link{report_discussion}},
  \code{\link{report_progress}},
  \code{\link{viz_waterfall}}

Other events: \code{\link{parse_issue_events}}
}
\concept{events}
\concept{issues}
