% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.projections}
\alias{summary.projections}
\title{Summary for projections objects}
\usage{
\method{summary}{projections}(
  object,
  quantiles = c(0.025, 0.25, 0.5, 0.75, 0.975),
  mean = TRUE,
  sd = TRUE,
  min = TRUE,
  max = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{projections} object to summarise}

\item{quantiles}{A \code{numeric} vector indicating which quantiles should be
computed; ignored if \code{FALSE} or of length 0}

\item{mean}{a \code{logical} indicating of the mean should be computed}

\item{sd}{a \code{logical} indicating of the standard deviation should be computed}

\item{min}{a \code{logical} indicating of the minimum should be computed}

\item{max}{a \code{logical} indicating of the maximum should be computed}

\item{...}{only preesnt for compatibility with the generic

if (require(incidence)) {
i <- incidence::incidence(as.Date('2020-01-23'))
si <- c(0.2, 0.5, 0.2, 0.1)
R0 <- 2

p <- project(x = i,
si = si,
R = R0,
n_sim = 2,
R_fix_within = TRUE,
n_days = 10,
model = "poisson"
)
summary(p)

}}
}
\description{
This method summarises predicted epidemic trajectories contained in a
\code{projections} object by days, deriving the mean, standard deviation, and
user-specified quantiles for each day.
}
\author{
Thibaut Jombart
}
