% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_pbmcapply.R
\name{handler_pbmcapply}
\alias{handler_pbmcapply}
\title{Progression Handler: Progress Reported via 'pbmcapply' Progress Bars (Text) in the Terminal}
\usage{
handler_pbmcapply(
  substyle = 3L,
  style = "ETA",
  file = stderr(),
  intrusiveness = getOption("progressr.intrusiveness.terminal", 1),
  target = "terminal",
  ...
)
}
\arguments{
\item{substyle}{(integer) The progress-bar substyle according to \code{\link[pbmcapply:progressBar]{pbmcapply::progressBar()}}.}

\item{style}{(character) The progress-bar style according to \code{\link[pbmcapply:progressBar]{pbmcapply::progressBar()}}.}

\item{file}{(connection) A \link[base:connections]{base::connection} to where output should be sent.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \code{\link[pbmcapply:progressBar]{pbmcapply::progressBar()}}.
}
\section{Requirements}{

This progression handler requires the \pkg{pbmcapply} package.
}

\section{Appearance}{

Since \code{style = "txt"} corresponds to using \code{\link[=handler_txtprogressbar]{handler_txtprogressbar()}}
with \code{style = substyle}, the main usage of this handler is with
\code{style = "ETA"} (default) for which \code{substyle} is ignored.
Below is how this progress handler renders by default at 0\%, 30\% and 99\%
progress:

With \code{handlers(handler_pbmcapply())}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ |                                         |   0\%, ETA NA
 |===========                           |  30\%, ETA 01:32
 |======================================|  99\%, ETA 00:01
}\if{html}{\out{</div>}}
}

\examples{
if (requireNamespace("pbmcapply", quietly = TRUE)) {

  handlers("pbmcapply")
  with_progress({ y <- slow_sum(1:10) })
  print(y)
  
}
}
