% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wprifm.R
\name{wprifm}
\alias{wprifm}
\title{Within-Person Random Intercept Factor Model}
\usage{
wprifm(data, scale = FALSE, save_model = FALSE)
}
\arguments{
\item{data}{Data.frame containing the manifest variables.}

\item{scale}{Should the data be scaled? Default = FALSE}

\item{save_model}{Should the temporary lavaan model syntax be saved. Default = FALSE}
}
\value{
an object of class \code{lavaan}
}
\description{
Within-Person Random Intercept Factor Model
}
\details{
This function performs the within-person random intercept factor model described in Davison, Kim, and Close (2009). For information about this model, please see this reference. This function returns an object of \code{lavaan} class and thus any generics defined for \code{lavaan} will work on this object. This function provides a simple wrapper for \code{lavaan}.
}
\examples{
data <- HolzingerSwineford1939[,7:ncol(HolzingerSwineford1939)]
wprifm(data, scale = TRUE)
}
\references{
Davison, M., Kim, S.-K., Close, C. (2009). Factor analytic modeling of within person variation in score profiles. Multivariate Behavioral Research, 44(5), 668 - 687.
}

