% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProfiles_optim.R
\name{getProfileInf_optim}
\alias{getProfileInf_optim}
\title{Generic profile inf function computation with optim}
\usage{
getProfileInf_optim(eta, Psi, f, fprime, d, options = NULL)
}
\arguments{
\item{eta}{\eqn{p} dimensional point where the function is to be evaluated}

\item{Psi}{projection matrix of dimension \code{pxd}}

\item{f}{function to be optimized (takes a vector y of dimension d and returns a real number)}

\item{fprime}{derivative of f (same format, returning a \eqn{d} dimensional vector)}

\item{d}{dimension of the input for f}

\item{options}{a list containing the options to be passed to optim:
\itemize{
\item{\code{par:}}{contains the starting point (a point in dimension d)}
\item{\code{lower:} }{the lower bounds for the optimization domain (see optim for details)}
\item{\code{upper:}}{the upper bounds for the optimization domain (see optim for details)}
}}
}
\value{
a real value corresponding to \eqn{min_{x \in D_Psi} f(x)}
}
\description{
Compute profile inf function for an arbitrary matrix \code{Psi} with with the L-BFGS-B algorithm of \link[stats]{optim}. Here the linear equality constraint is eliminated by using the Null space of \code{Psi}.
}
\seealso{
\link{getProfileSup_optim}, \link{plotMaxMin}
}
\author{
Dario Azzimonti
}
