% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMaxNumOpt.R
\name{getMaxMinMC}
\alias{getMaxMinMC}
\title{Coordinate profile extrema with MC}
\usage{
getMaxMinMC(x, f, fprime, coord, d, options = NULL)
}
\arguments{
\item{x}{one dimensional point where the function is to be evaluated}

\item{f}{function to be optimized (takes a vector y of dimension d and returns a real number)}

\item{fprime}{derivative of f (same format)}

\item{coord}{integer selecting the dimension that is fixed, the other ones are optimized over}

\item{d}{dimension of the input for f}

\item{options}{a list containing the options to be passed to the MC optimizer:
\itemize{
\item{\code{par:}}{contains the starting point (a point in dimension d-1)}
\item{\code{numMCsamples:}}{ number of MC samples}
\item{\code{rand}}{string that chooses the type of randomness in MC: "unif" (uniform in [lower,upper]), "norm" (independent normal with mean 0 and variance 1)}
\item{\code{lower:} }{the lower bounds for the optimization domain (see optim for details)}
\item{\code{upper:}}{the upper bounds for the optimization domain (see optim for details)}
}}
}
\value{
a real value corresponding to \eqn{max_{x_1,\dots, x_{coord-1},x_{coord+1}, \dots, x_d} f(x_1,\dots,x_d)}
}
\description{
Compute coordinate profile extrema with MC
}
\author{
Dario Azzimonti
}
