% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighborhood.R
\name{neighborhood}
\alias{neighborhood}
\title{Nearest neighborhoods for kernel smoothing}
\usage{
neighborhood(x, bandwidth = NULL, kernel = "box")
}
\arguments{
\item{x}{Numeric vector -- typically the observations of a continuous random
variate.}

\item{bandwidth}{Controls the distance between neighbors in a neighborhood.
It can be a decimal, i.e.\ the bandwidth, or the string `"smooth"', in which
case \code{N^{-1/4}} is used, \code{N} being the sample size, or \code{NULL}
in which case the \code{\link{dpik}} function of the package KernSmooth is
used to find the optimal bandwidth.}

\item{kernel}{Only the rectangular kernel ("box") is implemented.}
}
\value{
An object of class 'neighborhood'.  The value is a list that
includes the unique values of `x' (\code{values}) for which a neighborhood,
consisting of the nearest neighbors, is defined by the first neighbor
(\code{first.nbh}) of the usually very long vector \code{neighbors} and the
size of the neighborhood (\code{size.nbh}).

Further values are the arguments \code{bandwidth}, \code{kernel}, the total
sample size \code{n} and the number of unique values \code{nu}.
}
\description{
Nearest neighborhoods for the values of a continuous predictor. The result
is used for the conditional Kaplan-Meier estimator and other conditional
product limit estimators.
}
\examples{

d <- SimSurv(20)
neighborhood(d$X2)
}
\references{
Stute, W. "Asymptotic Normality of Nearest Neighbor Regression
Function Estimates", \emph{The Annals of Statistics}, 1984,12,917--926.
}
\seealso{
\code{\link{dpik}}, \code{\link{prodlim}}
}
\author{
Thomas Gerds
}
\keyword{smooth}
