% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/succession.R
\name{succession}
\alias{succession}
\title{Check succession between two activities}
\usage{
succession(activity_a, activity_b)
}
\arguments{
\item{activity_a}{Activity A. A character vector of length one. This should be an activity of the event log supplied to  `check_rule`.}

\item{activity_b}{Activity B. A character vector of length one. This should be an activity of the event log supplied to  `check_rule`.}
}
\description{
If activity A happens, it should be eventually followed by activity B.
If activity B happens, it should be preceded by activity A.
}
\examples{
library(bupaR)
library(eventdataR)

# Blood test should always happen before a MRI Scan,
# and both should happen when one of them happens.
patients \%>\%
check_rule(succession("Blood test","MRI SCAN"))

}
\seealso{
Other Declarative Rules: \code{\link{absent}},
  \code{\link{and}}, \code{\link{contains_between}},
  \code{\link{contains_exactly}}, \code{\link{contains}},
  \code{\link{ends}}, \code{\link{precedence}},
  \code{\link{responded_existence}},
  \code{\link{response}}, \code{\link{starts}},
  \code{\link{xor}}
}
\concept{Declarative Rules}
