% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contains_exactly.R
\name{contains_exactly}
\alias{contains_exactly}
\title{Check if activity is present (contained) in a case for exactly n times}
\usage{
contains_exactly(activity, n = 1)
}
\arguments{
\item{activity}{Activity too check. A character vector of length one. This should be an activity of the event log supplied to `check_rule`.}

\item{n}{The exact number of times the activity should be present.}
}
\description{
This rules examines whether the supplied activity is present in a case for an exact number of times.
}
\examples{
library(bupaR)
library(eventdataR)

# Each patient should have exactly one registration activity instance.

patients \%>\%
check_rule(contains_exactly("Registration", n = 1))

}
\seealso{
Other Declarative Rules: \code{\link{absent}},
  \code{\link{and}}, \code{\link{contains_between}},
  \code{\link{contains}}, \code{\link{ends}},
  \code{\link{precedence}},
  \code{\link{responded_existence}},
  \code{\link{response}}, \code{\link{starts}},
  \code{\link{succession}}, \code{\link{xor}}
}
\concept{Declarative Rules}
