% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processanimateR.R
\name{animate_process}
\alias{animate_process}
\title{Animate cases on a process map}
\usage{
animate_process(
  eventlog,
  processmap = process_map(eventlog, render = F, ...),
  renderer = renderer_graphviz(),
  mode = c("absolute", "relative", "off"),
  duration = 60,
  jitter = 0,
  timeline = TRUE,
  legend = NULL,
  initial_state = c("playing", "paused"),
  initial_time = 0,
  repeat_count = 1,
  repeat_delay = 0.5,
  epsilon_time = duration/1000,
  mapping = token_aes(),
  token_callback_onclick = c("function(svg_root, svg_element, case_id) {", "}"),
  token_callback_select = token_select_decoration(),
  activity_callback_onclick = c("function(svg_root, svg_element, activity_id) {", "}"),
  activity_callback_select = activity_select_decoration(),
  elementId = NULL,
  preRenderHook = NULL,
  width = NULL,
  height = NULL,
  sizingPolicy = htmlwidgets::sizingPolicy(browser.fill = TRUE, viewer.fill = TRUE,
    knitr.figure = FALSE, knitr.defaultWidth = "100\%", knitr.defaultHeight = "300"),
  ...
)
}
\arguments{
\item{eventlog}{The `bupaR` event log object that should be animated}

\item{processmap}{A process map created with `processmapR` (\code{\link{process_map}})
on which the event log will be animated. If not provided a standard process map will be generated
from the supplied event log.}

\item{renderer}{Whether to use Graphviz (\code{\link{renderer_graphviz}}) to layout and render the process map,
or to render the process map using Leaflet (\code{\link{renderer_leaflet}}) on a geographical map.}

\item{mode}{Whether to animate the cases according to their actual time of occurrence (`absolute`) or to start all cases at once (`relative`).}

\item{duration}{The overall duration of the animation, all times are scaled according to this overall duration.}

\item{jitter}{The magnitude of a random coordinate translation, known as jitter in scatterplots, which is added to each token.
Adding jitter can help to disambiguate tokens drawn on top of each other.}

\item{timeline}{Whether to render a timeline slider in supported browsers (Work only on recent versions of Chrome and Firefox).}

\item{legend}{Whether to show a legend for the `size` or the `color` scale. The default is not to show a legend.}

\item{initial_state}{Whether the initial playback state is `playing` or `paused`. The default is `playing`.}

\item{initial_time}{Sets the initial time of the animation. The default value is `0`.}

\item{repeat_count}{The number of times the process animation is repeated.}

\item{repeat_delay}{The seconds to wait before one repetition of the animation.}

\item{epsilon_time}{A (small) time to be added to every animation to ensure that tokens are visible.}

\item{mapping}{A list of aesthetic mappings from event log attributes to certain visual parameters of the tokens.
Use \code{\link{token_aes}} to create a suitable mapping list.}

\item{token_callback_onclick}{A JavaScript function that is called when a token is clicked.
The function is parsed by \code{\link{JS}} and received three parameters: `svg_root`, 'svg_element', and 'case_id'.}

\item{token_callback_select}{A JavaScript callback function called when token selection changes.}

\item{activity_callback_onclick}{A JavaScript function that is called when an activity is clicked.
The function is parsed by \code{\link{JS}} and received three parameters: 'svg_root', 'svg_element', and 'activity_id'.}

\item{activity_callback_select}{A JavaScript callback function called when activity selection changes.}

\item{elementId}{passed through to \code{\link{createWidget}}. A custom elementId is useful to capture the selection events
via input$elementId_tokens and input$elementId_activities when used in Shiny.}

\item{preRenderHook}{passed through to \code{\link{createWidget}}.}

\item{width, height}{Fixed size for widget (in css units).
The default is NULL, which results in intelligent automatic sizing based on the widget's container.}

\item{sizingPolicy}{Options that govern how the widget is sized in various
containers (e.g. a standalone browser, the RStudio Viewer, a knitr figure,
or a Shiny output binding). These options can be specified by calling the
\code{\link{sizingPolicy}} function.}

\item{...}{Options passed on to \code{\link{process_map}}.}
}
\description{
This function animates the cases stored in a `bupaR` event log on top of a process model.
 Each case is represented by a token that travels through the process model according to the waiting and processing times of activities.
 Currently, animation is only supported for process models created by \code{\link{process_map}} of the `processmapR` package.
 The animation will be rendered as SVG animation (SMIL) using the `htmlwidgets` framework. Each token is a SVG shape and customizable.
}
\examples{
data(example_log)

# Animate the process with default options (absolute time and 60s duration)
animate_process(example_log)
\donttest{
# Animate the process with default options (relative time, with jitter, infinite repeat)
animate_process(example_log, mode = "relative", jitter = 10, repeat_count = Inf)
}

}
\seealso{
\code{\link{process_map}}, \code{\link{token_aes}}
}
