% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modSummary.R
\name{modSummary}
\alias{modSummary}
\title{Make moderation effect summary}
\usage{
modSummary(semfit, mod = NULL, values = NULL, boot.ci.type = "bca.simple")
}
\arguments{
\item{semfit}{An object of class lavaan}

\item{mod}{name of moderator variable}

\item{values}{optional values of moderator}

\item{boot.ci.type}{Type of bootstrapping interval. Choices are c("norm","basic","perc",bca.simple")}
}
\description{
Make moderation effect summary
}
\examples{
require(lavaan)
labels=list(X="frame",W="skeptic",M="justify",Y="donate")
moderator=list(name='skeptic',site=list(c("a")))
model=tripleEquation(labels=labels,moderator=moderator,data=disaster,rangemode=2)
cat(model)
\dontrun{
semfit=sem(model=model,data=disaster,se="boot",bootstrap=100)
modSummary(semfit)
modSummaryTable(semfit)
labels=list(X="dysfunc",M="negtone",Y="perform",W="negexp")
moderator=list(name="negexp",site=list("b"))
model=tripleEquation(labels=labels,moderator=moderator,data=teams,rangemode=2)
cat(model)
semfit=sem(model,data=teams,se="boot",bootstrap=100)
modmedSummary(semfit)
modSummaryTable(semfit)
}
}
