% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condPlotCat2.R
\name{condPlotCat2}
\alias{condPlotCat2}
\title{Draw direct and indirect effect plot}
\usage{
condPlotCat2(
  labels = NULL,
  data = NULL,
  semfit,
  catlabels = NULL,
  digits = 3,
  add.point = FALSE,
  ...
)
}
\arguments{
\item{labels}{list of variable labels}

\item{data}{data.frame}

\item{semfit}{An object of class lavaan}

\item{catlabels}{labels for direct/indirect effects}

\item{digits}{Integer indicating the number of decimal places}

\item{add.point}{logical. Whether or not add points to the plot}

\item{...}{further argumnets to be passed to predict3d::add_lines()}
}
\description{
Draw direct and indirect effect plot
}
\examples{
library(lavaan)
labels=list(X="protest",W="sexism",M="respappr",Y="liking")
moderator=list(name="sexism",site=list(c("a","c")))
data1=addCatVars(protest,"protest",mode=3)
catlabels=c("Indirect: Protest\n   vs. No Protest",
      "Indirect: Collective\n       vs. Individual",
      "Direct: Protest\n vs. No Protest",
      "Direct: Collective\n      vs. Individual")
model=catMediation(X="protest",M="respappr",Y="liking",moderator=moderator,
       data=data1,maxylev=6,rangemode = 2)
semfit=sem(model=model,data=data1)
condPlotCat2(labels=labels,data=data1,semfit=semfit,catlabels=catlabels,
       xpos=c(0.7,0.3,0.3,0.7),add.point=TRUE)
}
