% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityPlot.R
\name{densityPlot}
\alias{densityPlot}
\title{Draw Smoothed Kernel density plot}
\usage{
densityPlot(
  x,
  sig = 0.05,
  digits = 3,
  xlab = "Indirect effect(ab)",
  ylab = NULL
)
}
\arguments{
\item{x}{A numeric vector}

\item{sig}{significant level. Default value is 0.05}

\item{digits}{Integer indicating the number of decimal places}

\item{xlab}{character. x axis label}

\item{ylab}{character. y axis label}
}
\description{
Draw Smoothed Kernel density plot
}
\examples{
require(lavaan)
labels=list(X="cond",M="pmi",Y="reaction")
model=tripleEquation(labels=labels)
\donttest{
set.seed(1234)
semfit=sem(model,data=pmi,se="boot",bootstrap=100)
bootData=getBootData(semfit)
bootData$indirect=bootData$a*bootData$b
densityPlot(bootData$indirect)
}
}
