% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conceptDiagram.R
\name{conceptDiagram2}
\alias{conceptDiagram2}
\title{Make concept Diagram}
\usage{
conceptDiagram2(
  X = "X",
  M = "M",
  Y = "Y",
  latent = rep(FALSE, 3),
  xb = FALSE,
  mc = FALSE,
  radx = 0.06,
  rady = 0.06,
  xmargin = 0.03,
  yinterval = NULL,
  box.col = "white",
  xlim = NULL,
  ylim = NULL,
  moderator = list(),
  labels = list(),
  covar = list()
)
}
\arguments{
\item{X}{character Name of independent variable}

\item{M}{character Name of mediator variable}

\item{Y}{character Name of dependent variable}

\item{latent}{Logical. whether or not X,Y and Z are latent variables or not}

\item{xb}{Logical. if positive draw line between X and (Y+Z)}

\item{mc}{Logical. if positive draw line between M and (X+Y)}

\item{radx}{horizontal radius of the box.}

\item{rady}{vertical radius of the box.}

\item{xmargin}{horizontal margin of plot}

\item{yinterval}{vertical interval between box}

\item{box.col}{fill color of box}

\item{xlim}{the x limits (min,max) of the plot}

\item{ylim}{the y limits (min,max) of the plot}

\item{moderator}{optional list of moderators}

\item{labels}{optional labels of X,Y and Z variables}

\item{covar}{covariate optional list of covariates}
}
\description{
Make concept Diagram
}
\examples{
labels=list(X="Time Spent in\n Grad School", M="# of\n Publications", Y="# of Job Offers")
conceptDiagram2(xb=TRUE,labels=labels)
moderator=list(name="Z1",label="Time Spent\n with Alex",pos=3,
    site=list(c("a","b","c")),latent=FALSE)
conceptDiagram2(moderator=moderator,labels=labels)
moderator=list(name=c("Z1","Z2"),label=c("Time Spent\n with Alex","Z2label"),pos=c(3,3),
    site=list(c("a","b","c"),c("b","c")),latent=c(FALSE,FALSE))
conceptDiagram2(moderator=moderator,labels=labels,yinterval=0.4)
covar=list(name=c("C1","C2"),label=c("sex","tenure"),site=list(c("Y"),c("Y")))
conceptDiagram2(M=NULL,moderator=list(name="M",pos=4,site=list("c"),latent=FALSE),covar=covar)
conceptDiagram2(covar=covar)
}
