% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCatEquation.R
\name{makeCatEquation}
\alias{makeCatEquation}
\title{Make equation for sem and lm}
\usage{
makeCatEquation(X = "X", Y = "Y", W = NULL, data, prefix = "b",
  maxylev = 6, grouplabels = list(), mode = 0)
}
\arguments{
\item{X}{Name of independent variable}

\item{Y}{Name of dependent variable}

\item{W}{Name of moderators}

\item{data}{a data.frame}

\item{prefix}{a character}

\item{maxylev}{maximal unique length of categorical variable}

\item{grouplabels}{A list}

\item{mode}{A numeric}
}
\description{
Make equation for sem and lm
}
\examples{
makeCatEquation(X="wt",Y="mpg",data=mtcars)
makeCatEquation(X="wt",Y="mpg",W="cyl",data=mtcars)
makeCatEquation(X="wt",Y="mpg",W=c("cyl","hp"),data=mtcars)
grouplabels=list(carb="f")
makeCatEquation(X="carb",Y="mpg",W=c("cyl","hp"),data=mtcars,maxylev=6)
makeCatEquation(X="carb",Y="mpg",W=c("cyl","hp"),data=mtcars)
cat(makeCatEquation(X="wt",Y="carb",W=c("am","hp"),data=mtcars,maxylev=6,grouplabels=grouplabels))
}
