% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{auctions}
\alias{auctions}
\title{Auction data}
\format{
\subsection{\code{auctions}}{

A data frame with 684 rows and 14 columns:
\describe{
\item{ebay_auction_id}{eBay auction ID number}
\item{bidders}{Number of bidders}
\item{finalprice}{Final sales price}
\item{seller_feedback_pct}{Seller's positive feedback percentage (e.g., 90 = 90\%)}
\item{seller_feedback_score}{Seller's feedback score (number of feedbacks received)}
\item{reserveprice}{Reserve price set by seller (value of 0.01 if no reserve price)}
\item{color_pink}{1 if iPod is pink, 0 otherwise}
\item{color_blue}{1 if iPod is blue, 0 otherwise}
\item{color_silver}{1 if iPod is silver, 0 otherwise}
\item{color_green}{1 if iPod is green, 0 otherwise}
\item{color_other}{1 if iPod is another color, 0 otherwise}
\item{new}{1 if condition listed is new, 0 otherwise}
\item{used}{1 if condition listed is used, 0 otherwise}
\item{refurb}{1 if condition listed is refurbished, 0 otherwise}
}
}
}
\source{
\url{https://journaldata.zbw.eu/dataset/econometrics-of-auctions-by-least-squares}
}
\usage{
auctions
}
\description{
Data on eBay auctions, based upon the paper "Econometrics of Auctions by Least
Squares" by Leonardo Rezende, Journal of Applied Econometrics, 2008, 23:925-948.
The dataset consists of eBay auctions for Apple iPod mini devices in June and
July 2006, limited to only auctions for the 4GB models.
}
\keyword{datasets}
