% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast_ratio.R
\name{contrast_ratio}
\alias{contrast_ratio}
\title{Contrast Ratio Between Colors}
\source{
\url{https://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-contrast.html}
}
\usage{
contrast_ratio(x, y)
}
\arguments{
\item{x}{A color object or vector of length 1 of any of the three kinds of R
color specifications, i.e., either a color name (as listed by colors()), a
hexadecimal string of the form "#rrggbb" or "#rrggbbaa" (see rgb), or a
positive integer i meaning palette()[i].}

\item{y}{A color object or vector of any of the three kinds of R color
specifications, i.e., either a color name (as listed by colors()), a
hexadecimal string of the form "#rrggbb" or "#rrggbbaa" (see rgb), or a
positive integer i meaning palette()[i].}
}
\value{
The elements of `y` with highest contrast to `x`.
}
\description{
Calculates the contrast ratio between `x` and the colors `y`. Contrast ratios
can range from 1 to 21 with 1 being no contrast (same color) and 21 being
highest contrast.
}
\details{
The formula for calculating contract ratio is

\deqn{(L1 + 0.05) / (L2 + 0.05)}

where

\itemize{
\item L1 is the relative luminance of the lighter of the colors, and
\item L2 is the relative luminance of the darker of the colors.
}

Relative luminance is calculated according to
\url{https://www.w3.org/TR/2008/REC-WCAG20-20081211/#relativeluminancedef}.
}
\examples{
contrast_ratio("red", "blue")
contrast_ratio("grey20", grey.colors(10))
contrast_ratio("white", c("white", "black"))
}
