% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/category_layer.R
\name{category_layer}
\alias{category_layer}
\alias{category_layer.Raster}
\alias{category_layer.default}
\title{Category layer}
\usage{
category_layer(x)

\method{category_layer}{Raster}(x)

\method{category_layer}{default}(x)
}
\arguments{
\item{x}{\code{\link[terra:rast]{terra::rast()}} object containing multiple
layers. Note that pixels must be 0, 1 or \code{NA} values.}
}
\value{
A \code{\link[terra:rast]{terra::rast()}} object.
}
\description{
Convert a \code{\link[terra:rast]{terra::rast()}} object where each layer corresponds to a different
identifier and values indicate the presence/absence of that category into a
\code{\link[terra:rast]{terra::rast()}} object containing categorical
identifiers.
}
\details{
This function is provided to help manage data that encompass
multiple management zones. For instance, this function may be helpful
for interpreting solutions for problems associated with multiple zones that
have binary decisions.
It is essentially a wrapper for \code{\link[terra:which]{terra::which.lyr()}}.
}
\examples{
# create a binary raster stack
x <- terra::rast(list(
 terra::rast(matrix(c(1, 0, 0, 1, NA, 0), nrow = 3)),
 terra::rast(matrix(c(0, 1, 0, 0, NA, 0), nrow = 3)),
 terra::rast(matrix(c(0, 0, 1, 0, NA, 1), nrow = 3))
))

# plot data
plot(x)

# convert to category layer
y <- category_layer(x)

# plot result
\dontrun{
plot(y)
}
}
\seealso{
\code{\link[=binary_stack]{binary_stack()}}.
}
