% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_problem.R
\name{write_problem}
\alias{write_problem}
\title{Write problem}
\usage{
write_problem(x, path)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} (i.e. \code{\linkS4class{ConservationProblem}}) object.}

\item{path}{\code{character} file path to save the problem formulation.
The argument should contain a \code{".lp"} or \verb{.mps"} file extension
to specify whether the problem formulation will be saved in the
\href{https://www.gurobi.com/documentation/9.1/refman/lp_format.html}{LP} or
\href{https://www.gurobi.com/documentation/9.1/refman/mps_format.html}{MPS}
format (respectively).}
}
\value{
Invisible \code{TRUE} indicating success.
}
\description{
Save the mathematical formulation for a conservation planning \code{\link[=problem]{problem()}}
to a file for mixed integer programming solvers. Note that this function
requires the \pkg{Rsymphony} package to be installed.
}
\examples{
\dontrun{
# set seed for reproducibility
set.seed(500)

# load data
data(sim_pu_raster, sim_features, sim_pu_zones_stack, sim_features_zones)

# create minimal problem
p <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.1) \%>\%
      add_binary_decisions()

# save problem to file (using the Rsymphony R package)
write_problem(p, "model.lp")
}

}
