% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate data}
\usage{
simulate_data(x, n, model, transform = identity, ...)
}
\arguments{
\item{x}{\code{\linkS4class{RasterLayer}} object to use as
a template.}

\item{n}{\code{integer} number of species to simulate.}

\item{model}{\code{\link[RandomFields:RP]{RandomFields::RP()}} model object
to use for simulating data.}

\item{transform}{\code{function} to transform values output
from the random fields simulation.}

\item{...}{additional arguments passed to
\code{\link[RandomFields:RFsimulate]{RandomFields::RFsimulate()}}.}
}
\value{
\code{\linkS4class{RasterStack}} object with a
layer for each species.
}
\description{
Simulate spatially auto-correlated data.
}
\examples{
\dontrun{
# create raster
r <- raster(ncol=10, nrow=10, xmn=0, xmx=1, ymn=0, ymx=1)
values(r) <- 1

# simulate data using a Gaussian field
d <- simulate_data(r, n = 1, model = RandomFields::RMgauss())

# plot simulated data
plot(d, main = "random Gaussian field")
}
}
\seealso{
\code{\link[RandomFields:RFsimulate]{RandomFields::RFsimulate()}},
\code{\link[=simulate_cost]{simulate_cost()}}, \code{\link[=simulate_species]{simulate_species()}}.
}
