% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{princurve-package}
\alias{princurve-package}
\alias{princurve}
\title{Fit a Principal Curve in Arbitrary Dimension}
\description{
Fit a principal curve which describes a smooth curve that passes through the \code{middle}
of the data \code{x} in an orthogonal sense. This curve is a non-parametric generalization
of a linear principal component. If a closed curve is fit (using \code{smoother = "periodic_lowess"})
then the starting curve defaults to a circle, and each fit is followed by a bias correction
suggested by Jeff Banfield.
}
\references{
Hastie, T. and Stuetzle, W.,
 \href{https://www.jstor.org/stable/2289936}{Principal Curves},
 JASA, Vol. 84, No. 406 (Jun., 1989), pp. 502-516,
 DOI: \href{https://doi.org/10.2307/2289936}{10.2307/2289936}
 (\href{https://web.stanford.edu/~hastie/Papers/principalcurves.pdf}{PDF}).

 See also Banfield and Raftery (JASA, 1992).
}
\seealso{
\code{\link{principal_curve}}, \code{\link{project_to_curve}}
}
\keyword{nonparametric}
\keyword{regression}
\keyword{smooth}
