% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{pedar_mask}
\alias{pedar_mask}
\title{Pedar mask template}
\usage{
pedar_mask(
  pressure_data,
  mask_type,
  n_sensors = 1,
  image = "max",
  mask_name = "custom_mask",
  plot = TRUE
)
}
\arguments{
\item{pressure_data}{List. First item is a 3D array covering each timepoint
of the measurement.}

\item{mask_type}{String. Note, we refer to rearfoot as hindfoot
"mask1" splits the insole into 4 regions using sensel boundaries:
hindfoot, midfoot, forefoot, and toes-- https://www.ncbi.nlm.nih.gov/pmc/articles/PMC9470545/
"mask2" splits the insole into 4 regions using percentages:
hindfoot, forefoot, hallux, and lesser toes-- https://jfootankleres.biomedcentral.com/articles/10.1186/1757-1146-7-18
"mask3" splits the foot into 9 regions using sensel boundaries:
 medial hindfoot, lateral hindfoot, medial midfoot, lateral midfoot, MTPJ1,
 MTPJ2-3, MTPJ4-5, hallux, and lesser toes-- https://jfootankleres.biomedcentral.com/articles/10.1186/1757-1146-7-20
"custom" allows you to select a mask region}

\item{n_sensors}{Numeric. Number of sensors in the custom mask region. Custom
masks will be added to the end of the existing list of masks.}

\item{image}{String."max" = footprint of maximum sensors. Or numeric for a
specified frame number}

\item{mask_name}{String. Add names to custom masks}

\item{plot}{Logical. Plot masks if TRUE}
}
\value{
List. Masks are added to the relevant A 3D array covering each
timepoint of the measurement for the selected region. z dimension represents
time
}
\description{
Add a Pedar mask template using 3 in current literature
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pedar_data <- system.file("extdata", "pedar_example.asc", package = "pressuRe")
pressure_data <- load_pedar(pedar_data)
pressure_data <- pedar_mask(pressure_data, "mask3")
\dontshow{\}) # examplesIf}
}
\author{
Scott Telfer \email{scott.telfer@gmail.com}
}
