% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bipiped_value_to_vector.R
\name{bipiped_value_to_vector}
\alias{bipiped_value_to_vector}
\alias{bipiped_values_to_vector}
\title{Convert a "bipiped" value (or vector of values) to a vector}
\usage{
bipiped_value_to_vector(x)

bipiped_values_to_vector(x)
}
\arguments{
\item{x}{The value or vector of values.}
}
\value{
A vector or list of vectors.
}
\description{
"Bipiped" means that different values are separated by a pair of
pipes (\code{||}), like the logical OR operator in R. Use
\code{bipiped_value_to_vector()} for single values, and
\code{bipiped_values_to_vector()} for a vector of values, in which case a list
is returned.
}
\examples{
exampleValue <-
  paste0('"Purposefully select" || "Aselect" || ',
         '"Likely self-selected" || "Ameliorated self-selection"');
bipiped_value_to_vector(exampleValue);
}
