% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{use_precommit_config}
\alias{use_precommit_config}
\title{Initiate a pre-commit config file}
\usage{
use_precommit_config(
  config_source = getOption("precommit.config_source"),
  force = FALSE,
  open = rstudioapi::isAvailable(),
  verbose = FALSE,
  root = here::here()
)
}
\arguments{
\item{config_source}{Path or URL to a \code{.pre-commit-config.yaml}. This
config file will be hard-copied into \code{root}. If \code{NULL}, we check if
\code{root} is a package or project directory using
\code{\link[rprojroot:find_root_file]{rprojroot::find_package_root_file()}}, and resort to an appropriate default
config. See section 'Copying an existing config file'.}

\item{force}{Whether to replace an existing config file.}

\item{open}{Whether or not to open the .pre-commit-config.yaml after
it's been placed in your repo. The default is \code{TRUE} when working in
RStudio. Otherwise, we recommend manually inspecting the file.}

\item{verbose}{Whether or not to communicate what's happening.}

\item{root}{The path to the root directory of your project.}
}
\value{
Character vector of length one with the path to the config file used.
}
\description{
Initiate a pre-commit config file
}
\section{Copying an existing config file}{

You can use an existing \code{.pre-commit-config.yaml} file when initializing
pre-commit with \code{\link[=use_precommit]{use_precommit()}} using the argument \code{config_source} to
copy an existing config file into your repo. This argument defaults to the R
option \code{precommit.config_source}, so you may want to set this option in
your \code{.Rprofile} for convenience. Note that this is \strong{not} equivalent to the
\code{--config} option in the CLI command \verb{pre-commit install} and similar,
which do \emph{not} copy a config file into a project root (and allow to put it
under version control), but rather link it in some more or less transparent
way.
}

\examples{
\dontrun{
use_precommit_config()
}
}
