% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{precommit_docopt}
\alias{precommit_docopt}
\title{Provide a singular interface for hook calls to docopt}
\usage{
precommit_docopt(doc, args = commandArgs(trailingOnly = TRUE), ...)
}
\arguments{
\item{doc}{\code{character} vector with command line specification.}

\item{args}{\code{character} vector of command line arguments.
Defaults to \code{commandArgs(trailingOnly=TRUE)}.}

\item{...}{Additional parameters passed to \code{docopt}.}
}
\description{
docopt provides different processing for a single string
than an array/vector. As \verb{"string"`` and }c("string")`
are semantically equivalent in R, this can create problems
when a single parameter is provided. Thus, this function
wraps docopt to ensure that the args will always be
interpreted as a vector.
}
\details{
This function is only exported for use in hook scripts, but it's not intended
to be called by the end-user directly.
}
\seealso{
Other hook script helpers: 
\code{\link{diff_requires_run_roxygenize}()},
\code{\link{dirs_R.cache}()},
\code{\link{may_require_permanent_cache}()},
\code{\link{robust_purl}()},
\code{\link{roxygen_assert_additional_dependencies}()},
\code{\link{roxygenize_with_cache}()}
}
\concept{hook script helpers}
\keyword{internal}
