% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CATE_surv.R
\name{twoarmsurv.dr}
\alias{twoarmsurv.dr}
\title{Doubly robust estimators of the coefficients in the contrast regression
 as well as their covariance matrix and convergence information}
\usage{
twoarmsurv.dr(
  ynew,
  dnew,
  trt,
  x.cate,
  tau0,
  weightsurv,
  ps,
  f1.predictor,
  f0.predictor,
  error.maxNR = 0.001,
  max.iterNR = 100,
  tune = c(0.5, 2)
)
}
\arguments{
\item{ynew}{Truncated survival time; vector of size \code{n}}

\item{dnew}{Event indicator after truncation; vector of size \code{n}}

\item{trt}{Treatment received; vector of size \code{n} with treatment coded as 0/1.}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates specified in the outcome model; dimension \code{n} by \code{p.cate}.}

\item{tau0}{The truncation time for defining restricted mean time lost.}

\item{weightsurv}{Estimated inverse probability of censoring weights with truncation for all observations; vector of size \code{n}.}

\item{ps}{Estimated propensity scores for all observations; vector of size \code{n}}

\item{f1.predictor}{Initial predictions of the outcome (restricted mean time loss) conditioned on the covariates \code{x.cate} for treatment group trt = 1;
\code{mu_1(x.cate)}, step 1 in the two regression; vector of size \code{n}}

\item{f0.predictor}{Initial predictions of the outcome (restricted mean time loss) conditioned on the covariates \code{x.cate} for treatment group trt = 0;
\code{mu_0(x.cate)}, step 1 in the two regression; vector of size \code{n}}

\item{error.maxNR}{A numerical value > 0 indicating the minimum value of the mean absolute
error in Newton Raphson algorithm. Used only if \code{score.method = 'contrastReg'}.
Default is \code{0.001}.}

\item{max.iterNR}{A positive integer indicating the maximum number of iterations in the
Newton Raphson algorithm. Used only if \code{score.method = 'contrastReg'}.
Default is \code{100}.}

\item{tune}{A vector of 2 numerical values > 0 specifying tuning parameters for the
Newton Raphson algorithm. \code{tune[1]} is the step size, \code{tune[2]} specifies a
quantity to be added to diagonal of the slope matrix to prevent singularity.
Used only if \code{score.method = 'contrastReg'}. Default is \code{c(0.5, 2)}.}
}
\value{
coef: Doubly robust estimators of the contrast regression coefficients \code{delta_0}; vector of size \code{p.cate} + 1 (intercept included)
        converge: Indicator that the Newton Raphson algorithm converged for \code{delta_0}; boolean
}
\description{
Newton-Raphson algorithm is used to solve the estimating equation \code{bar S_n (delta) = 0}
}
