% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATE.R
\name{atefit}
\alias{atefit}
\title{Doubly robust estimator of and inference for the average treatment effect for count, survival and continuous data}
\usage{
atefit(
  response,
  data,
  cate.model,
  ps.model,
  ps.method = "glm",
  ipcw.model = NULL,
  ipcw.method = "breslow",
  minPS = 0.01,
  maxPS = 0.99,
  followup.time = NULL,
  tau0 = NULL,
  surv.min = 0.025,
  interactions = TRUE,
  n.boot = 500,
  seed = NULL,
  verbose = 0
)
}
\arguments{
\item{response}{A string describing the type of outcome in the data. Allowed values include
"count" (see \code{\link{catecvcount}()}), "survival" (see
\code{\link{catecvsurv}()}) and "continuous" (see \code{\link{catecvmean}()}).}

\item{data}{A data frame containing the variables in the outcome, propensity score, and inverse
probability of censoring models (if specified); a data frame with \code{n} rows (1 row per observation).}

\item{cate.model}{A formula describing the outcome model to be fitted.
The outcome must appear on the left-hand side. For survival outcomes,
a \code{Surv} object must be used to describe the outcome.}

\item{ps.model}{A formula describing the propensity score (PS) model to be fitted. The treatment must
appear on the left-hand side. The treatment must be a numeric vector coded as 0/1.
If data are from a randomized controlled trial, specify \code{ps.model = ~1} as an intercept-only model.}

\item{ps.method}{A character value for the method to estimate the propensity score.
Allowed values include one of:
\code{'glm'} for logistic regression with main effects only (default), or
\code{'lasso'} for a logistic regression with main effects and LASSO penalization on
two-way interactions (added to the model if interactions are not specified in \code{ps.model}).
Relevant only when \code{ps.model} has more than one variable.}

\item{ipcw.model}{A formula describing the inverse probability of censoring weighting (IPCW)
model to be fitted. The left-hand side must be empty. Only applies for survival outcomes.
Default is \code{NULL}, which corresponds to specifying the IPCW with the same covariates
as the outcome model \code{cate.model}, plus the treatment.}

\item{ipcw.method}{A character value for the censoring model. Only applies for survival
outcomes. Allowed values are: \code{'breslow'} (Cox regression with Breslow estimator of t
he baseline survivor function), \code{'aft (exponential)'}, \code{'aft (weibull)'},
\code{'aft (lognormal)'} or \code{'aft (loglogistic)'} (accelerated failure time model
with different distributions for y variable). Default is \code{'breslow'}.}

\item{minPS}{A numerical value (in [0, 1]) below which estimated propensity scores should be
truncated. Default is \code{0.01}.}

\item{maxPS}{A numerical value (in (0, 1]) above which estimated propensity scores should be
truncated. Must be strictly greater than \code{minPS}. Default is \code{0.99}.}

\item{followup.time}{A column name in \code{data} specifying the maximum follow-up time,
interpreted as the potential censoring time. Only applies for survival outcomes.
Default is \code{NULL}, which corresponds to unknown potential censoring time.}

\item{tau0}{The truncation time for defining restricted mean time lost. Only applies for
survival outcomes. Default is \code{NULL}, which corresponds to setting the truncation time as the
maximum survival time in the data.}

\item{surv.min}{Lower truncation limit for the probability of being censored.
It must be a positive value and should be chosen close to 0. Only applies for survival
outcomes. Default is \code{0.025}.}

\item{interactions}{A logical value indicating whether the outcome model should assume interactions
between \code{x} and \code{trt}. Applies only to count outcomes. If \code{TRUE}, interactions will
be assumed only if at least 10 patients received each treatment option. Default is \code{TRUE}.}

\item{n.boot}{A numeric value indicating the number of bootstrap samples used. Default is \code{500}.}

\item{seed}{An optional integer specifying an initial randomization seed for reproducibility.
Default is \code{NULL}, corresponding to no seed.}

\item{verbose}{An integer value indicating whether intermediate progress messages and histograms should
be printed. \code{1} indicates messages are printed and \code{0} otherwise. Default is \code{0}.}
}
\value{
For count response, see description of outputs in \code{\link{atefitcount}()}.
For survival response, see description of outputs in \code{\link{atefitsurv}()}.
}
\description{
Doubly robust estimator of the average treatment effect between two treatments, which is the rate ratio
for count outcomes, the restricted mean time lost ratio for survival outcomes and the mean difference for continuous outcome. Bootstrap is used for
inference.
}
\details{
For count response, see details in \code{\link{atefitcount}()}.
For survival response, see details in \code{\link{atefitsurv}()}.
}
\examples{

# Count outcome
output <- atefit(response = "count",
                 data = countExample,
                 cate.model = y ~ age + female + previous_treatment +
                              previous_cost + previous_number_relapses +
                              offset(log(years)),
                 ps.model = trt ~ age + previous_treatment,
                 n.boot = 50,
                 seed = 999)
output
plot(output)

\donttest{

# Survival outcome
tau0 <- with(survivalExample,
                 min(quantile(y[trt == "drug1"], 0.95), quantile(y[trt == "drug0"], 0.95)))

output2 <- atefit(response = "survival",
                  data = survivalExample,
                  cate.model = survival::Surv(y, d) ~ age + female +
                        previous_cost + previous_number_relapses,
                        ps.model = trt ~ age + previous_treatment,
                  tau0 = tau0,
                  seed = 999)
output2
plot(output2)

}
}
