% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{interact}
\alias{interact}
\title{Calculate interaction statistics for variables in a prediction rule ensemble 
(pre)}
\usage{
interact(object, varnames = NULL, nullmods = NULL,
  penalty.par.val = "lambda.1se", quantprobs = c(0.05, 0.95),
  plot = TRUE, col = c("darkgrey", "lightgrey"),
  ylab = "Interaction strength", main = "Interaction test statistics",
  se.linewidth = 0.05, legend.text = c("observed",
  "null model median"), parallel = FALSE, k = 10, verbose = FALSE,
  ...)
}
\arguments{
\item{object}{an object of class \code{\link{pre}}.}

\item{varnames}{character vector. Names of variables for which interaction
statistics should be calculated. If \code{NULL}, interaction statistics for
all predictor variables with non-zeor coefficients will be calculated (which
may take a long time).}

\item{nullmods}{object with bootstrapped null interaction models, resulting
from application of \code{bsnullinteract}.}

\item{penalty.par.val}{character or numeric. Value of the penalty parameter
\eqn{\lambda} to be employed for selecting the final ensemble. The default
\code{"lambda.min"} employs the \eqn{\lambda} value within 1 standard
error of the minimum cross-validated error. Alternatively, 
\code{"lambda.min"} may be specified, to employ the \eqn{\lambda} value
with minimum cross-validated error, or a numeric value \eqn{>0} may be 
specified, with higher values yielding a sparser ensemble. To evaluate the 
trade-off between accuracy and sparsity of the final ensemble, inspect
\code{pre_object$glmnet.fit} and \code{plot(pre_object$glmnet.fit)}.}

\item{quantprobs}{numeric vector of length two. Probabilities that should be
used for plotting the range of bootstrapped null interaction model statistics.
Only used when \code{nullmods} argument is specified and \code{plot = TRUE}.
The default yields sample quantiles corresponding to .05 and .95 probabilities.}

\item{plot}{logical. Should interaction statistics be plotted?}

\item{col}{character vector of length one or two. The first value specifies 
the color to be used for plotting the interaction statistic from the training
data, the second color is used for plotting the interaction statistic from 
the bootstrapped null interaction models. Only used when \code{plot = TRUE}. 
Only the first element will be used if \code{nullmods = NULL}.}

\item{ylab}{character string. Label to be used for plotting y-axis.}

\item{main}{character. Main title for the bar plot.}

\item{se.linewidth}{numeric. Width of the whiskers of the plotted standard 
error bars (in inches).}

\item{legend.text}{character vector of length two to be used for plotting
the legend. Only used when \code{nullmods} is specified. If \code{FALSE},
no legend is plotted.}

\item{parallel}{logical. Should parallel foreach be used? Must register
parallel beforehand, such as doMC or others.}

\item{k}{integer. Calculating interaction test statistics is computationally
intensive, so  calculations are split up in several parts to prevent memory
allocation errors. If a memory allocation error still occurs, increase k.}

\item{verbose}{logical. Should progress information be printed to the
command line?}

\item{...}{Additional arguments to be passed to \code{barplot}.}
}
\value{
Function \code{interact()} returns and plots interaction statistics
for the specified predictor variables. If nullmods is not specified, it 
returns and plots only the interaction test statistics for the specified 
fitted prediction rule ensemble. If nullmods is specified, the function 
returns a list, with elements \code{$fittedH2}, containing the interaction
statistics of the fitted ensemble, and \code{$nullH2}, which contains the
interaction test statistics for each of the bootstrapped null interaction 
models.
 
If \code{plot = TRUE} (the default), a barplot is created with the 
interaction test statistic from the fitted prediction rule ensemble. If 
\code{nullmods} is specified, bars representing the median of the 
distribution of interaction test statistics of the bootstrapped null 
interaction models are plotted. In addition, error bars representing the
quantiles of the distribution (their value specified by the \code{quantprobs} 
argument) are plotted. These allow for testing the null hypothesis of no 
interaction effect for each of the input variables. 

Note that the error rates of null hypothesis tests of interaction effects 
have not yet been studied in detail, but results are likely to get more 
reliable when the number of bootstrapped null interaction models is larger.
The default of the \code{bsnullinteract} function is to generate 10 
bootstrapped null interaction datasets, to yield shorter computation times.
To obtain a more reliable result, however, users are advised to
set the \code{nsamp} argument \eqn{\ge 100}.

See also section 8 of Friedman & Popescu (2008).
}
\description{
\code{interact} calculates test statistics for assessing the strength of
interactions between a set of user-specified input variable(s), and all 
other input variables.
}
\details{
Can be computationally intensive, especially when nullmods is 
specified, in which case setting \verb{parallel = TRUE} may improve speed.
}
\examples{
\donttest{set.seed(42)
 airq.ens <- pre(Ozone ~ ., data=airquality[complete.cases(airquality),])
 interact(airq.ens, c("Temp", "Wind", "Solar.R"))}
}
\references{
Fokkema, M. (2018). Fitting prediction rule ensembles with R package pre.
\url{https://arxiv.org/abs/1707.07149}.

Friedman, J. H., & Popescu, B. E. (2008). Predictive learning 
via rule ensembles. \emph{The Annals of Applied Statistics, 2}(3), 916-954.
}
\seealso{
\code{\link{pre}}, \code{\link{bsnullinteract}}
}
