% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_benchmark.R
\name{run_benchmark}
\alias{run_benchmark}
\title{Run microbenchmark with specified tools and test sets}
\usage{
run_benchmark(testset, toolset, times = 5, unit = "ms",
  use_sys_time = FALSE)
}
\arguments{
\item{testset}{A character vector to specify a test set generated by
\code{\link{create_testset}}.}

\item{toolset}{A character vector to specify a tool set generated by
\code{\link{create_toolset}}.}

\item{times}{The number of iteration used in
\code{\link[microbenchmark]{microbenchmark}}.}

\item{unit}{A single string to specify the unit used in
\code{\link[microbenchmark]{summary.microbenchmark}}.}

\item{use_sys_time}{A Boolean value to specify
\code{\link[base]{system.time}} is used instead of
\code{\link[microbenchmark]{summary.microbenchmark}}.}
}
\value{
A data frame of microbenchmark results with additional columns.
}
\description{
The \code{run_benchmark} function runs
    \code{\link[microbenchmark]{microbenchmark}} for specified tools
    and test datasets
}
\examples{
\dontrun{
## Benchmarking for b10 and i10 test sets and crv5, auc5, and def5 tool sets
testset <- create_testset("bench", c("b10", "i10"))
toolset <- create_toolset(set_names = "def5")
res1 <- run_benchmark(testset, toolset)
res1
}

}
\seealso{
\code{\link{create_testset}} to generate a test dataset.
   \code{\link{create_toolset}} to generate a tool set.
   \code{\link[microbenchmark]{microbenchmark}} for benchmarking
   details.
}
