% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pkg_info}
\alias{pkg_info}
\title{Get information about the current package}
\usage{
pkg_info(pkg_path = ".", ...)
}
\arguments{
\item{pkg_path}{Path to the package directory. Default is \code{"."} for the current working directory, which assumes developer is working in R package root. However, this can be set to another path as needed.}

\item{...}{Arguments passed to \link[rprojroot:find_root_file]{rprojroot::find_package_root_file}.}
}
\value{
A list of information about the package.
\itemize{
\item \code{pkgroot}: Root directory of the package.
\item \code{pkgdeps}: Package dependencies from \code{Imports} in the \code{DESCRIPTION}.
\item \code{descfile}: File path to the \code{DESCRIPTION} file.
\item \code{pkgname}: Package name.
\item \code{pkgver}: Package version.
}
}
\description{
Returns information about the current package in a list which can be passed to other functions.
}
\examples{
\dontrun{
# Specify path to example package source and copy to tempdir()
# Note that in practice you do not need to copy to a tempdir()
# And in fact it may be easiest to use pracpac relative to your package directory root
ex_pkg_src <- system.file("hellow", package = "pracpac", mustWork = TRUE)
file.copy(from = ex_pkg_src, to = tempdir(), recursive = TRUE)

# This will succeed if this is a package
pkg_info(pkg_path = file.path(tempdir(), "hellow"))
# This will fail if this is not a package location
pkg_info(pkg_path = tempdir())
}
}
