% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emupicture.R
\name{emupicture}
\alias{emupicture}
\title{Make Praat Picture style plots in EMU}
\usage{
emupicture(
  db_handle,
  session = "0000",
  bundle,
  pitch_ssffExt = NULL,
  formant_ssffExt = NULL,
  intensity_ssffExt = NULL,
  ...
)
}
\arguments{
\item{db_handle}{The handle of an EMU database loaded into R.}

\item{session}{String giving the name of the session where the sound file
to plot is located.
Default is \code{0000}.}

\item{bundle}{String giving the name of the bundle with the sound file to plot.}

\item{pitch_ssffExt}{String giving the file extension for an SSFF track with
pitch data to plot. Default is \code{NULL}.}

\item{formant_ssffExt}{String giving the file extension for an SSFF track
with formant data to plot. Default is \code{NULL}.}

\item{intensity_ssffExt}{String giving the file extension for an SSFF track with intensity data to
plot. Default is \code{NULL}.}

\item{...}{Further arguments passed to \code{praatpicture}.}
}
\value{
No return value, produces a plot.
}
\description{
Generate plots in the style of Praat Pictures from sound files and annotations
in an EMU database.
}
\examples{
\donttest{
# Create demo data and load demo database
emuR::create_emuRdemoData(tempdir())
db_path <- paste0(tempdir(), '/emuR_demoData/ae_emuDB')
db <- emuR::load_emuDB(db_path)

emuR::list_bundles(db)
emupicture(db, bundle='msajc003', tg_tiers=c('Text', 'Tone'))

# Plot SSFF track data

emuR::list_ssffTrackDefinitions(db)
emupicture(db, bundle='msajc003', frames=c('sound', 'formant'),
proportion=c(30,70), formant_ssffExt='fms')
}
}
\seealso{
See \link{praatpicture} for more details on how to customize plots.
}
