% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es.d.R
\name{es.d}
\alias{es.d}
\title{Cohen d effect size calculation for one or two means}
\usage{
es.d(delta = NULL, sd = 1)
}
\arguments{
\item{delta}{If one mean: muA (the true mean) - mu0 (the mean under the null). If two means: DeltaA (the true difference mu1 - mu2) - Delta0 (the difference under the null).}

\item{sd}{The estimated standard deviation; defaults to 1.}
}
\value{
A list of the arguments and the d effect size.
}
\description{
This function takes as inputs a difference between two means and a standard deviation
and outputs the d effect size as defined by Cohen (1988),
also called the standardized mean difference.
}
\details{
Cohen J (1988) Statistical Power Analysis for the Behavioral Sciences, 2nd edition.
Lawrence Erlbaum Associates, Hillsdale, New Jersey
}
\examples{
es.d(delta = 6.5 - 5.7, sd = 0.4)
}
