% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr.1samp.R
\name{corr.1samp}
\alias{corr.1samp}
\title{Power calculation for test of one correlation coefficient}
\usage{
corr.1samp(
  N = NULL,
  rho0 = 0,
  rhoA = NULL,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{N}{The sample size.}

\item{rho0}{The correlation coefficient under the null hypothesis; defaults to 0.}

\item{rhoA}{The correlation coefficient under the alternative hypothesis.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Calculates power and sample size for a test that the correlation coefficient in a single population
is equal to (or less than or greater than) a specified value. Can solve for power, N or alpha.
}
\examples{
corr.1samp(N = 100, rhoA = 0.2, sides = 1)
corr.1samp(N = 100, rho0 = 0.2, rhoA = 0.4, sides = 1)
}
