% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop.1samp.R
\name{prop.1samp}
\alias{prop.1samp}
\title{Power calculation for one-sample proportion test}
\usage{
prop.1samp(
  N = NULL,
  p0 = NULL,
  pA = NULL,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{N}{The sample size.}

\item{p0}{The proportion under the null.}

\item{pA}{The true proportion.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Performs power and sample size calculations for a one-sample test of a proportion.
Calculations use the large-sample normal approximation to the binomial. Can solve
for power, N or alpha.
}
\examples{
prop.1samp(N = NULL, p0 = 0.2, pA = 0.3, power = 0.8, sides = 1)
prop.1samp(N = NULL, p0 = 0.4, pA = 0.5, power = 0.8, sides = 1)

}
