% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlrF.overall.R
\name{mlrF.overall}
\alias{mlrF.overall}
\title{Power calculation for a multiple linear regression overall F test}
\usage{
mlrF.overall(
  N = NULL,
  p = NULL,
  Rsq = NULL,
  fsq = NULL,
  alpha = 0.05,
  power = NULL,
  random = FALSE,
  v = FALSE
)
}
\arguments{
\item{N}{The sample size.}

\item{p}{The number of predictors.}

\item{Rsq}{The squared population multiple correlation coefficient.}

\item{fsq}{The f-squared effect size. Either Rsq OR fsq must be specified.}

\item{alpha}{The significance level or type 1 error rate; defaults to 0.05.}

\item{power}{The specified level of power.}

\item{random}{Whether the values of the predictors are random; defaults to FALSE.}

\item{v}{Either TRUE for verbose output or FALSE to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Conducts power and sample size calculations for an overall (or omnibus) F test
in a multiple linear regression model.
This is a test that all coefficients other than the intercept are equal to zero.
Can solve for power, N or alpha.
}
\details{
Either Rsq OR fsq must be specified. These are related as fsq = Rsq/(1-Rsq).
Rsq is the proportion of the total variation in Y that is explained by
linear relationship with the predictors. Specifying random = TRUE
yields a calculation in which Y and the predictors are assumed to have
a multivariate normal distribution; see Crespi (2025).
}
\examples{
mlrF.overall(N = 400, p = 2, Rsq = 0.02)
mlrF.overall(N = 400, p = 2, fsq = 0.02 / (1 - 0.02))
mlrF.overall(N = 109, p = 1, Rsq = 0.3^2)
mlrF.overall(N = 50, p = 1, Rsq = 0.2)
mlrF.overall(N = 50, p = 3, Rsq = 0.2)
mlrF.overall(N = 50, p = 5, Rsq = 0.2)
mlrF.overall(N = 400, p = 2, Rsq = 0.02, random = TRUE)
}
