% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_experimental_file.R
\name{create_experimental_file}
\alias{create_experimental_file}
\title{Create experimental file}
\usage{
create_experimental_file(
  peptides,
  times = c(0.167, 1, 5, 25, 1440),
  charge,
  n_replicates = 3,
  mass_deviations = 50,
  intensity_deviations = NULL,
  file_type = "DynamX"
)
}
\arguments{
\item{peptides}{a data frame of sequences (\code{sequence}), \code{Protein},
and \code{Start}, \code{End} and parameters except \code{times}
that can be used for simulating mass spectra.
See \code{\link[powerHaDeX]{simulate_theoretical_spectra}} for more details
about the additional parameters.}

\item{times}{a vector of times at which deuteration levels will be measured
(seconds)}

\item{charge}{vector of charges of the peptide ion. If NULL, one value is
sampled from vector 2:6. Default NULL.}

\item{n_replicates}{number of technical replicates to create}

\item{mass_deviations}{mass deviation in parts per million. Either a single
number (then the error at each time point will be the same) or a vector of
the same length as number of unique time points in the experiment. The error
will be sampled from normal distribution with standard deviation equal to
\deqn{mass_deviations * undeuterated_mass/1e6}
Default to 50.}

\item{intensity_deviations}{optional, standard deviations of random noise
that will be added to intensities. Either a single number (then the error at
each time point will be the same) or a vector of the same length as number of
unique time points in the experiment. The error will be sampled from normal
distribution with these standard deviations.Default \code{NULL}.}

\item{file_type}{the type of file. Default to "DynamX".}
}
\value{
data table. The table of HDX-MS results consistent with `file_type`
format.
}
\description{
This function generates replications of mass spectra that are
consistent with common experimental data files
}
\examples{
peptides <- data.frame(sequence = c("FPTTKTY", "LVRKDLQN"),
                       protection_factor = c(10, 100))
create_experimental_file(peptides, charge = 1:3)

}
