% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_tests.R
\name{test_semiparametric}
\alias{test_semiparametric}
\title{Semiparametric test for differences in deuteration levels}
\usage{
test_semiparametric(data, significance_level = 0.05)
}
\arguments{
\item{data}{data.table with deuteration curves}

\item{significance_level}{significance level for tests}
}
\value{
This function returns a data table compatible with the function
\code{\link[powerHaDeX]{calculate_hdx_power}}.
}
\description{
This function performs the semiparametric test for differences
in deuteration levels. Its input and output are compatible with
the function \code{\link[powerHaDeX]{calculate_hdx_power}}.
}
\details{
This function uses \code{\link[powerHaDeX]{truncated_lines}}.
The knots considered in the testing procedure are chosen using ridge
regression.
}
\examples{
theo_spectra_pf_100 <- simulate_theoretical_spectra(sequence = "LVRKDLQN",
                                                    charge = c(3, 5),
                                                    protection_factor = 100,
                                                    times = c(0.167, 5, 10, 30),
                                                    pH = 7.5,
                                                    temperature = 15,
                                                    n_molecules = 500,
                                                    time_step_const = 1,
                                                    use_markov = TRUE)
theo_spectra_pf_200 <- simulate_theoretical_spectra(sequence = "LVRKDLQN",
                                                    charge = c(3, 5),
                                                    protection_factor = 200,
                                                    times = c(0.167, 5, 10, 30),
                                                    pH = 7.5,
                                                    temperature = 15,
                                                    n_molecules = 500,
                                                    time_step_const = 1,
                                                    use_markov = TRUE)

theo_spectra_two_states <- rbind(theo_spectra_pf_100, theo_spectra_pf_200)

deut_curves_p_states <- get_noisy_deuteration_curves(theo_spectra_two_states,
                                                     n_replicates = 4,
                                                     n_experiments = 1,
                                                     reference = 100)[[1]][[1]]
test_semiparametric(deut_curves_p_states)

}
\seealso{
Other tests:

- \code{\link[powerHaDeX]{test_houde}}

- \code{\link[powerHaDeX]{test_hdx_analyzer}}

-\code{\link[powerHaDeX]{test_memhdx_model}}

Or \code{\link[powerHaDeX]{calculate_hdx_power}} for estimation of power
of tests for differences in deuteration levels.
}
