% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerHE.R
\name{powerHE}
\alias{powerHE}
\title{Hierarchical Endpoints}
\usage{
powerHE(
  endpoints_input,
  sample.size = NA,
  power = NA,
  alpha = 0.05,
  rratio = 0.5,
  output = "ALL"
)
}
\arguments{
\item{endpoints_input}{A list with each endpoint being a nested list.
\itemize{
  \item \bold{Time to Event (type = "TTE")}:
   \itemize{
      \item tte.winning.direction: Winning direction. Input "GT" if longer time to event is a win or "LT" if shorter time to event is a win.
      \item s: Follow-up time.
      \item input \bold{either}:
      \itemize{
         \item er.a and er.b: Where er.a is the probability of event in group A at the specified follow-up time and er.b is the probability of event in group B at the specified follow-up time.
         \item hr and er.b: Where hr is the hazard ratio (group A relative to group B) and er.b is the probability of event in group B at the specified follow-up time.
      }
    }
  \item \bold{Continuous (type = "Continuous")}:
   \itemize{
      \item continuous.winning.direction: Winning direction. Input "GT" if larger value is a win or "LT" if smaller value is a win.
      \item input \bold{either}:
      \itemize{
         \item mu.a and mu.b: Where mu.a is the mean in group A and mu.b is the mean in group B.
         \item mean.diff and mu.b: Where mean.diff is the mean difference of group A minus group B and mu.b is the mean in group B.
      }
      \item sd.a: Standard deviation in group A.
      \item sd.b: Standard deviation in group B.
      \item delta: Threshold to win. If the winning direction is “GT,” group A wins over group B for a pair of subjects if the value from the subject in group A exceeds the value from the subject in group B by more than delta.
      }
  \item \bold{Binary (1/0) (type = "Binary")}:
   \itemize{
      \item binary.winning.direction: Winning direction. Input "GT" if 1 is a win or "LT" if a 0 is a win.
      \item input \bold{either}:
      \itemize{
         \item pi.a and pi.b: Where pi.a is the Prob(Y=1) in group A and pi.b is the Prob(Y=1) in group B.
         \item prob.diff and pi.b: Where prob.diff is the Prob(Y=1) of group A minus group B and pi.b is the Prob(Y=1) in group B.
      }
   }
  \item \bold{Count (# of events) (type = "Count")}:
   \itemize{
      \item count.winning.direction: Winning direction. Input "GT" if a larger number of counts is a win or "LT" if a smaller number of counts is a win.
      \item input \bold{either}:
      \itemize{
         \item lam.a and lam.b: Where lam.a is the number of counts/events in group A and lam.b is the number of counts/events in group B.
         \item rr and lam.b: Where rr is the relative rate of group A over group B and lam.b is the number of counts/events in group B.
      }
   }
  \item \bold{Ordinal (1, 2, ..., J) (type = "Ordinal")}:
   \itemize{
      \item ordinal.winning.direction: Winning direction. Input "GT" if higher level of category is a win or "LT" if lower level of category is a win.
      \item pi.ordinal.a: Prob(Y=1), ..., Prob(Y=J) in group A (comma-separated).
      \item pi.ordinal.b: Prob(Y=1), ..., Prob(Y=J) in group B (comma-separated).
      }
}}

\item{sample.size}{An integer (enter \bold{either} sample.size or power).}

\item{power}{A probability between 0 and 1 (enter \bold{either} sample.size or power).}

\item{alpha}{Two-sided Type 1 Error.}

\item{rratio}{Probability randomized to group A.
\itemize{
   \item As a result, 1 - rratio will be the probability randomized to group B.
   }}

\item{output}{Specifies the output type. Options are:
\itemize{
  \item \bold{ALL} (default): Displays all results based on all parameters.
  \item \bold{WR}: Displays results related to win ratios.
  \item \bold{WO}: Displays results related to win odds.
  \item \bold{NB}: Displays results related to net benefits.
  \item \bold{DOOR}: Displays results related to desirability of outcome ranking.
  }}
}
\value{
A named list of results based on the specified 'output' parameter.
}
\description{
This function can calculate sample size given power or vice versa based on
inputs which represent the marginals of each endpoint. The function assumes
that the correlation between endpoints are 0, and it can output the following
probabilities: marginal and overall probability of ties, marginal and overall
WR (win ratios), marginal and overall WO (win odds), marginal and overall NB
(net benefits), marginal and overall DOOR (desirability of outcome ranking).
If given power, the function can calculate sample size for WR, WO, NB, and
DOOR. If given sample size, the function can calculate power for WR, WO, NB,
and DOOR. It is suggested to assign the output to an object, which defaults
to showing all the probabilities listed above.
Examples are given below.
}
\examples{
# For all examples, A is the default for the active group and B is the
# default for the control group.

### Two continuous (type = "Continuous"):
# For the first endpoint, the marginal distribution for the active group (A)
# follows a normal distribution with a mean of 15 (mu.a = 15) and a standard
# deviation of 60 (sd.a = 60), while the control group (B) also follows a
# normal distribution with a mean of 4 (mu.b = 4) and a standard deviation of
# 60 (sd.b = 60). The threshold to win is 5 (delta = 5) and a longer time to
# event is better (continuous.winning.direction = “GT”).

# For the second endpoint, the marginal distribution for the active group (A)
# follows a normal distribution with a mean of 40 (mu.a = 40) and a standard
# deviation of 24 (sd.a = 24), while the control group (B) also follows a
# normal distribution with a mean of 30 (mu.b = 30) and a standard deviation
# of 24 (sd.b = 24). The threshold to win is 5 (delta = 5) and a longer time
# to event is better (continuous.winning.direction = “GT”).

# We seek to find the required sample size to achieve a power of 0.85
# (power = 0.85) for detecting an overall win ratio calculated based on the
# inputted parameters of the marginal distributions with an alpha level of
# 0.05 (alpha = 0.05) and a 1:1 randomization ratio (rratio = 0.5).

endpoints_input <- list(
  list(type = "Continuous",
       mu.a = 15,
       mu.b = 4,
       sd.a = 60,
       sd.b = 60,
       delta = 5,
       continuous.winning.direction = "GT"),
  list(type = "Continuous",
       mu.a = 40,
       mu.b = 30,
       sd.a = 24,
       sd.b = 24,
       delta = 5,
       continuous.winning.direction = "GT")
)
powerHE(endpoints_input,
    power = 0.85,
    alpha = 0.05,
    rratio = 0.5,
    output = "ALL")

### Two binary (type = "Binary"):
# For the first endpoint, the marginal distribution for the active group (A)
# follows a binomial distribution with a success probability of 0.90
# (pi.a = 0.9) for one trial, while the control group (B) also follows a
# binomial distribution with a success probability of 0.85 (pi.b = 0.85) for
# one trial. A 1 represents a win (binary.winning.direction = "GT").

# For the second endpoint, the marginal distribution for the active group (A)
# follows a binomial distribution with a success probability of 0.80
# (pi.a = 0.8) for one trial, while the control group (B) also follows a
# binomial distribution with a success probability of 0.75 (pi.b = 0.75) for
# one trial. A 1 represents a win (binary.winning.direction = "GT").

# We seek to find the achieved power for detecting an overall win ratio
# calculated based on the inputted parameters of the marginal distributions
# with a sample size of 1098 (sample.size = 1098) with an alpha level
# of 0.05 (alpha = 0.05) and a 1:1 randomization ratio (rratio = 0.5).

endpoints_input <- list(
  list(type = "Binary",
      pi.a = 0.9,
      pi.b = 0.85,
      binary.winning.direction = "GT"),
  list(type = "Binary",
      pi.a = 0.8,
      pi.b = 0.75,
      binary.winning.direction = "GT")
)
powerHE(endpoints_input,
    sample.size = 1098,
    alpha = 0.05,
    rratio = 0.5,
    output = "ALL")

### One binary (type = "Binary") and one continuous (type = "Continuous"):
# For the first endpoint, the marginal distribution for the active group (A)
# follows a binomial distribution with a success probability of 0.96
# (pi.a = 0.96) for one trial, while the control group (B) also follows a
# binomial distribution with a success probability of 0.95 (pi.b = 0.95). A 1
# represents a win (binary.winning.direction = "GT").

# For the second endpoint, the marginal distribution for the active group (A)
# follows a normal distribution with a mean of 36 (mu.a = 36) and a standard
# deviation of 24 (sd.a = 24), while the control group (B) also follows a
# normal distribution with a mean of 31 (mu.b = 31) and a standard
# deviation of 24 (sd.b = 24). The threshold to win is 5 (delta = 5) and a
# longer time to event is better (continuous.winning.direction = “GT”).

# We seek to find the required sample size to achieve a power of 0.85
# (power = 0.85) for detecting an overall win ratio calculated based on the
# inputted parameters of the marginal distributions with an alpha level of
# 0.05 (alpha = 0.05) and a 1:1 randomization ratio (rratio = 0.5).

endpoints_input <- list(
  list(type = "Binary",
       pi.a = 0.96,
       pi.b = 0.95,
       binary.winning.direction = "GT"),
  list(type = "Continuous",
       mu.a = 36,
       mu.b = 31,
       sd.a = 24,
       sd.b = 24,
       delta = 5,
       continuous.winning.direction = "GT")
)
powerHE(endpoints_input,
    power = 0.85,
    alpha = 0.05,
    rratio = 0.5,
    output = "ALL")

### One TTE (type = "TTE") and one count (type = "Count"):
# For the first endpoint, the marginal distribution for the active group (A)
# follows an exponential distribution with a rate parameter of 0.16, while
# the control group (B) also follows an exponential distribution with a rate
# parameter of 0.20 (hr.a = 0.16 / 0.20 = 0.8). The follow-up time is 5 years
# (s = 5, er.b = 1 - exp(-0.20 * 5) = 0.63212), and a longer time to event is
# a win (tte.winning.direction = "GT").

# For the second endpoint, the number of hospitalizations for the active
# (A) follows a Poisson distribution with a mean of 0.75 (lam.a = 0.75),
# while the number of hospitalization in the control group (B) also follows a
# Poisson distribution with a mean of 1.1 (lam.b = 1.1). A smaller count is a
# win (count.winning.direction = "GT").

# We seek to find the achieved power for detecting an overall win ratio
# calculated based on the inputted parameters of the marginal distributions
# with a sample size of 770 (sample.size = 770) with an alpha level
# of 0.05 (alpha = 0.05) and a 1:1 randomization ratio (rratio = 0.5).

endpoints_input <- list(
  list(type = "TTE",
       tte.winning.direction = "GT",
       hr.a = 0.8,
       er.b = 0.63212,
       s = 5),
  list(type = "Count",
       count.winning.direction = "LT",
       lam.a = 0.75,
       lam.b = 1.1)
)
powerHE(endpoints_input,
    sample.size = 770,
    alpha = 0.05,
    rratio = 0.5,
    output = "ALL")

### Two ordinal (each with ordinal categories 1, 2, and 3) (type = "Ordinal"):
# For the first endpoint, the marginal distribution for the active group (A)
# follows a multinomial distribution with probabilities for the three
# categories (1, 2, 3) given by (0.45, 0.30, 0.25) (pi.ordinal.a = c(0.45,
# 0.3, 0.25)), where each of the probabilities represent the likelihood of a
# subject being in categories 1, 2, or 3. The control group (B) also follows
# a multinomial distribution with probabilities for the same three categories
# given by (0.50, 0.30, 0.20) (pi.ordinal.b = c(0.5, 0.3, 0.2)). A subject in
# a higher ordinal category wins over a subject in a lower ordinal category
# (ordinal.winning.direction = “GT").

# For the second endpoint, the marginal distribution for the active group (A)
# follows a multinomial distribution with probabilities for the three
# categories (1, 2, 3) given by (0.30, 0.30, 0.40) (pi.ordinal.a = c(0.3,
# 0.3, 0.4)), where each of the probabilities represent the likelihood of a
# subject being in categories 1, 2, or 3. The control group (B) also follows
# a multinomial distribution with probabilities for the same three categories
# given by (0.40, 0.30, 0.30) (pi.ordinal.b = c(0.4, 0.3, 0.3)). A subject in
# a higher ordinal category wins over a subject in a lower ordinal category
# (ordinal.winning.direction = “GT").

# We seek to find the required sample size to achieve a power of 0.85
# (power = 0.85) for detecting an overall win ratio calculated based on the
# inputted parameters of the marginal distributions with an alpha level of
# 0.05 (alpha = 0.05) and a 1:1 randomization ratio (rratio = 0.5).

endpoints_input <- list(
  list(type = "Ordinal",
       pi.ordinal.a = c(0.45, 0.3, 0.25),
       pi.ordinal.b = c(0.5, 0.3, 0.2),
       ordinal.winning.direction = "GT"),
  list(type = "Ordinal",
       pi.ordinal.a = c(0.3, 0.3, 0.4),
       pi.ordinal.b = c(0.4, 0.3, 0.3),
       ordinal.winning.direction = "GT")
)
powerHE(endpoints_input,
    power = 0.85,
    alpha = 0.05,
    rratio = 0.5,
    output = "ALL")
}
\keyword{endpoints}
