% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_multi_xy.R
\name{as_multi_xy.list}
\alias{as_multi_xy.list}
\title{Create a multiXY object from a list of XRPD data}
\usage{
\method{as_multi_xy}{list}(x, ...)
}
\arguments{
\item{x}{a list of XRPD data frames (column 1 = 2theta, column 2 = counts)}

\item{...}{other arguments}
}
\value{
a \code{multiXY} object.
}
\description{
\code{as_multi_xy.list} takes a list of XRPD data and ensures that they meet
various requirements to create a multiXY object. These requirements
include that each item in the list contains 2 columns of numeric data in a
data frame. \code{as_multi_xy.list} also checks that all names are unique.
Once a \code{multiXY} object has been created, it can easily be plotted using
the associated \code{plot.multiXY} method.
}
\examples{
#' #load soils data
data(soils)

#extract first two samples from the list
soils <- soils[c(1:2)]

#convert to multiXY
soils <- as_multi_xy(soils)
}
