% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.powRICLPM}
\alias{plot.powRICLPM}
\title{Plot Results From \code{powRICLPM} Object}
\usage{
\method{plot}{powRICLPM}(
  x,
  y = "power",
  ...,
  parameter = NULL,
  color_by = "time_points",
  shape_by = "reliability",
  facet_by = "ICC"
)
}
\arguments{
\item{x}{A \code{powRICLPM} object.}

\item{y}{(optional) A \code{character} string, specifying which outcome is plotted on the y-axis (see "Details").}

\item{...}{(don't use)}

\item{parameter}{Character string of length 1, denoting the parameter to visualize the results for.}

\item{color_by}{Character string of length 1, denoting what variable to map to color (see "Details").}

\item{shape_by}{Character string of length 1, denoting what variable to map to point shapes (see "Details").}

\item{facet_by}{Character string of length 1, denoting what variable to facet by (see "Details").}
}
\value{
A \code{ggplot2} object.
}
\description{
Visualizes (using \pkg{ggplot2}) the results from a \code{powRICLPM} analysis, for a specific parameter, across all experimental conditions. By default, sample size is plotted on the x-axis, power on the y-axis, with results colored by the number of time points, wrapped by the proportion of between-unit variance, and shaped by the reliability. Optionally, other variables can be mapped to the y-axis, x-axis, color, shape, and facets.
}
\details{
\subsection{Mapping Options}{The following outcomes can be plotted on the y-axis:

\itemize{
\item \code{average}: The average estimate.
\item \code{MSE}: The mean square error.
\item \code{coverage}: The coverage rate
\item \code{accuracy}: The average width of the confidence interval.
\item \code{SD}: Standard deviation of parameter estimates.
\item \code{SEAvg}: Average standard error.
\item \code{bias}: The absolute difference between the average estimate and population value.
}

The following variables can be mapped to color, shape, and facet:

\itemize{
\item \code{sample_size}: Sample size.
\item \code{time_points}: Time points.
\item \code{ICC}: Intraclass correlation (ICC).
\item \code{reliability}: Item-reliablity.
}
}
}
\examples{
\dontshow{
load(system.file("extdata", "out_preliminary.RData", package = "powRICLPM"))
}
# Visualize power for "wB2~wA1" across simulation conditions
plot(out_preliminary, parameter = "wB2~wA1")

# Visualize bias for "wB2~wA1" across simulation conditions
plot(out_preliminary, y = "bias", parameter = "wB2~wA1")

# Visualize coverage rate for "wB2~wA1" across simulation conditions
plot(out_preliminary, y = "coverage", parameter = "wB2~wA1")

# Visualize MSE for autoregressive effect across simulation conditions
plot(out_preliminary, y = "MSE", parameter = "wA2~wA1")

# Error: No parameter specified
try(plot(out_preliminary))
}
\seealso{
\itemize{
\code{\link{give}}: Extract information (e.g., performance measures) for a specific parameter, across all experimental conditions. This function is used internally by \code{plot.powRICLPM}.
}
}
