% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.poth.R
\name{subset.poth}
\alias{subset.poth}
\title{Calculate the local POTH for a subset of treatments}
\usage{
\method{subset}{poth}(x, subset, top, bottom, ...)
}
\arguments{
\item{x}{An object of class \code{poth}.}

\item{subset}{A character vector of treatment names to consider as the set
of competing treatments.}

\item{top}{A single integer to define the number of treatments with the
largest ranking metric to consider in subset.}

\item{bottom}{A single integer to define the number of treatments with the
smallest ranking metric to consider in subset.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
An R object of class \code{poth}.
}
\description{
Calculate the local POTH for a subset of treatments
}
\examples{
library("netmeta")
data(smokingcessation)
p1 <- pairwise(list(treat1, treat2, treat3),
  event = list(event1, event2, event3), n = list(n1, n2, n3),
  data = smokingcessation, sm = "OR")
net1 <- netmeta(p1, random = FALSE)

# Use P-scores to calculate local POTH for treatments "A" and "C"
subset(poth(net1), subset = c("A", "C"))

# Use P-scores to calculate local POTH for first three treatments
subset(poth(net1), top = 3)

# Use P-scores to calculate local POTH for first three treatments
subset(poth(net1), bottom = 3)

}
