% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcpotential.R
\name{mcpotential}
\alias{mcpotential}
\title{Compute the Potential Model using Parallelization}
\usage{
mcpotential(x, y, var, fun, span, beta, limit = 3 * span, ncl, size = 500)
}
\arguments{
\item{x}{an sf object (POINT), the set of known observations to estimate
the potentials from.}

\item{y}{an sf object (POINT), the set of unknown units for which the
function computes the estimates.}

\item{var}{names of the variables in \code{x} from which potentials are
computed. Quantitative variables with no negative values.}

\item{fun}{spatial interaction function. Options are "p"
(pareto, power law) or "e" (exponential).
For pareto the interaction is defined as: (1 + alpha * mDistance) ^ (-beta).
For "exponential" the interaction is defined as:
exp(- alpha * mDistance ^ beta).
The alpha parameter is computed from parameters given by the user
(\code{beta} and \code{span}).}

\item{span}{distance where the density of probability of the spatial
interaction function equals 0.5.}

\item{beta}{impedance factor for the spatial interaction function.}

\item{limit}{maximum distance used to retrieve \code{x} points, in map units.}

\item{ncl}{number of clusters. \code{ncl} is set to
\code{parallel::detectCores() - 1} by default.}

\item{size}{\code{mcpotential} splits \code{y} in smaller chunks and
dispatches the computation in \code{ncl} cores, \code{size} indicates the
size of each chunks.}
}
\value{
If only one variable is computed a vector is returned, if more than
one variable is computed a matrix is returned.
}
\description{
This function computes the potential model with a cutoff 
distance and parallel
computation.
}
\examples{
\donttest{
library(sf)
g <- create_grid(x = n3_poly, res = 20000)
pot <- mcpotential(
  x = n3_pt, y = g, var = "POP19",
  fun = "e", span = 75000, beta = 2, 
  limit = 300000, 
  ncl = 2
)
g$OUTPUT <- pot
equipot <- equipotential(g, var = "OUTPUT", mask = n3_poly)
plot(equipot["center"], pal = hcl.colors(nrow(equipot), "cividis"))
}
}
