% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/junrui.edit.R
\name{fragmentation_long2}
\alias{fragmentation_long2}
\title{Fragmentation Metrics for Whole Dataset}
\usage{
fragmentation_long2(
  count.data,
  weartime,
  thresh,
  bout.length = 1,
  metrics = c("mean_bout", "TP", "Gini", "power", "hazard", "all"),
  by = c("day", "subject")
)
}
\arguments{
\item{count.data}{\code{data.frame} of dimension n*1442 containing the 1440 minute activity data for all n subject days.
The first two columns have to be ID and Day.}

\item{weartime}{\code{data.frame} with dimension of \code{count.data}.
The first two columns have to be ID and Day.}

\item{thresh}{threshold to binarize the data.}

\item{bout.length}{minimum duration of defining an active bout; defaults to 1.}

\item{metrics}{What is the fragmentation metrics to exract. Can be
"mean_bout","TP","Gini","power","hazard",or all the above metrics "all".}

\item{by}{Determine whether fragmentation is calcualted by day or by subjects (i.e. aggregate bouts across days).
by-subject is recommended to gain more power.}
}
\value{
A dataframe with some of the following columns
\item{ID}{identifier of the person}
\item{Day}{indicator of which day of activity it is, can be a numeric vector of sequence 1,2,... or a string of date}
\item{mean_r}{mean sedentary bout duration}
\item{mean_a}{mean active bout duration}
\item{SATP}{sedentary to active transition probability}
\item{ASTP}{bactive to sedentary transition probability}
\item{Gini_r}{Gini index for active bout}
\item{Gini_a}{Gini index for sedentary bout}
\item{h_r}{hazard function for sedentary bout}
\item{h_a}{hazard function for active bout}
\item{alpha_r}{power law parameter for sedentary bout}
\item{alpha_a}{power law parameter for active bout}
}
\description{
Fragmentation methods to study the transition between two states, e.g.
sedentary v.s. active.This function is a whole dataset wrapper for \code{fragmentation}
}
\details{
Metrics include
mean_bout (mean bout duration),
TP (between states transition probability),
Gini (gini index),
power (alapha parameter for power law distribution)
hazard (average hazard function)
}
