% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_fit_helper.R
\name{fit_cross}
\alias{fit_cross}
\title{Cross-fitting helper}
\usage{
fit_cross(Y_def, X_def, W_def, data.size, fun.call, k.folds, method_used)
}
\arguments{
\item{Y_def}{An argument that control the Y input (used for argument passing)}

\item{X_def}{An argument that control the X input (used for argument passing)}

\item{W_def}{An argument that control the W input (used for argument passing)}

\item{data.size}{Parses the length of the dataset (nrow) for splitting.}

\item{fun.call}{Designates the function to use for cross-fitting.}

\item{k.folds}{The number of k-folds for daataset splitting, defaults to 3.}

\item{method_used}{The method to used when applying predict trough a helper function (do not worry about this!).}
}
\value{
A list with four elements: The mean estimate of \eqn{\theta}, the standard error of the mean estimate, the associated  moment conditions, and the estimated heterogenous effects for a combined estimate from a simulation run.
}
\description{
Implements k-fold cross-fitting with the supplied method, is a helper function that the user should not need.
}
\details{
This only implements the k-fold crossfitting, not the n.repeat simulation - if you intend to use this function, it works as a 'naive' double machine learning.
}
\examples{


  n = 2000; p = 10
  X = matrix(rnorm(n*p), n, p)
  W = rbinom(n, 1, 0.4 + 0.2 * (X[,1] > 0))
  Y = pmax(X[,1], 0) * W + X[,2] + pmin(X[,3], 0) + rnorm(n)


fit_cross(Y_def = Y, X_def = X, W_def = W, data.size = 2000, fun.call = glmnet_helper(X,Y,W),
k.folds = 3, method_used = "glmnet")



}
