% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_rmse.R
\name{pp_rmse}
\alias{pp_rmse}
\title{RMS Error}
\usage{
pp_rmse(target, source, sourcecode, sourcepop, targetpop, title)
}
\arguments{
\item{target}{target file in \code{sf} format}

\item{source}{census source file in \code{sf} format}

\item{sourcecode}{source id column \code{string}}

\item{sourcepop}{source population column name \code{string}}

\item{targetpop}{target estimated pop column name \code{string}}

\item{title}{title of scatterplot \code{string}}
}
\value{
rms error, correlation, lm line and scatterplot
}
\description{
This function calculates the rmse between the source and target counts
}
\examples{
    library(populR)
    data("target")
    data("source")

    # areametric
    pop_aw <- pp_estimate(source = source, target = target, sourcepop = 'pop',
        sourcecode = 'sid')

    # areametric rmse
    pp_rmse(target = pop_aw, source = source, sourcecode = 'sid',
        sourcepop = 'pop', targetpop = 'pp_est', title = 'Areametric')

    # volumetric
    pop_vw <- pp_estimate(source = source, target = target, sourcepop = 'pop',
        sourcecode = 'sid', volume = 'floors')

    # volumetric rmse
    pp_rmse(target = pop_vw, source = source, sourcecode = 'sid',
        sourcepop = 'pop', targetpop = 'pp_est', title = 'Volumetric')


}
