% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matplot2.R
\name{matplot2}
\alias{matplot2}
\title{Plot a matrix}
\usage{
matplot2(x, proportions = FALSE, legend = "topright", xlab = NULL,
  ylab = NULL, type = "l", las = 1, pch = c(15:18, 1:3), lwd = 1,
  lty = 1:nrow(x), col = rainbow(nrow(x)), lcex = 1, lbty = "o",
  lcol = 1, ltitle = NULL, lsort = TRUE, ...)
}
\arguments{
\item{x}{a matrix}

\item{proportions}{If TRUE, then  plot proportional changes}

\item{legend}{a \code{\link{legend}} keyword or vector of x,y coordinates,
defaults to top-right corner}

\item{xlab}{a label for the x axis}

\item{ylab}{a label for the y axis}

\item{type}{plot type, default line}

\item{las}{style of axis labels, default horizontal}

\item{pch}{point types}

\item{lwd}{line width}

\item{lty}{line type}

\item{col}{color}

\item{lcex}{legend size expansion}

\item{lbty}{legend box type}

\item{lcol}{number of columns in legend}

\item{ltitle}{legend title}

\item{lsort}{sort  legend by decreasing order of mean number in row}

\item{\dots}{additional options are passed to \code{\link{plot}} function}
}
\value{
A matrix plot
}
\description{
Plot the rows of a matrix.  Useful for displaying a matrix of stage vectors,
survival rates and sensitivities.
}
\note{
Only a few basic legend options are available.  For more control, set
legend=NA and run separately
}
\examples{
# survival rates
x <- calathea[9:12]
x <- sapply(x, function(x) colSums(splitA(x, r=1:2)$T))
matplot2(t(x), legend="bottomright", ylab="Survival",
 main="Calathea survival curves")
# Growth rates - do not sort legend
x <- sapply(calathea[-17], lambda)
x <- matrix(x, nrow=4, byrow=TRUE, dimnames= list(paste("plot", 1:4), 1982:1985))
matplot2(x, type='b', lsort=FALSE, ylab="Growth rate", main="Calathea growth rates")
# Convergence to stable stage (excluding seeds)
x <- pop.projection(calathea[[7]], rep(1,8), 10)
matplot2(x$stage.vectors[-1,], prop=TRUE,
  main="Calathea stage vectors", lcex=.7)

}
\seealso{
\code{\link{matplot}} and \code{\link{stage.vector.plot}}
}
\author{
Chris Stubben
}
