% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bonferroniIntervals}
\alias{bonferroniIntervals}
\title{Compute Bonferroni Intervals}
\usage{
bonferroniIntervals(X, alpha = 0.05, k = 2)
}
\arguments{
\item{X}{is a matrix or data frame that contains the responses. Each column
represents a different population.}

\item{alpha}{denotes the significance level of the intervals to be formed.}

\item{k}{corresponds to the number of populations to be selected.}
}
\value{
The function returns a matrix with k rows and 3 columns. This is
similar to the output of the predict.lm function of R.
}
\description{
This function will compute apply the Bonferroni correction to the selected
populations.
}
\details{
If there are p populations, then the Bonferroni correction will be
applied by using \eqn{\alpha / p} instead of just p.
}
\examples{
set.seed(18)
p <- 10; n <- 10
Xmat <- matrix(rnorm(p*n), nrow=n, ncol=p)
colnames(Xmat) <- paste("p.", 1:p, sep="")
bonferroniIntervals(Xmat, alpha=0.1, k=4)
}
\seealso{
\code{\link{asymmetricIntervals}}, \code{\link{bootstrapIntervals}}
}

