% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_definitions.R
\name{as.Date.yrs}
\alias{as.Date.yrs}
\title{Coerce Fractional Year Values to Date Values}
\usage{
\method{as.Date}{yrs}(x, ...)
}
\arguments{
\item{x}{an \code{yrs} object created by \code{get.yrs}}

\item{...}{unused, included for compatibility with other \code{as.Date}
methods}
}
\description{
Coerces an \code{yrs} object to a \code{Date} object.
Some loss of information comes if \code{year.length = "approx"} 
was set when using \code{\link{get.yrs}}, so the transformation back
to \code{Date} will not be perfect there. With \code{year.length = "actual"}
the original values are perfectly retrieved.
}
\examples{

test <- copy(sire)

## approximate year lengths: here 20 \% have an extra day added
test$dg_yrs <- get.yrs(test$dg_date)
summary(test$dg_yrs)
dg_date2 <- as.Date(test$dg_yrs)
summary(as.numeric(dg_date2 - test$dg_date))

## using actual year lengths
test$dg_yrs <- get.yrs(test$dg_date, year.length = "actual")
summary(test$dg_yrs)
dg_date2 <- as.Date(test$dg_yrs)
summary(as.numeric(dg_date2 - test$dg_date))
}
\author{
Joonas Miettinen
}

