% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_na.R
\name{replace_na}
\alias{replace_na}
\title{Replace missing values}
\usage{
replace_na(data, replace, ...)
}
\arguments{
\item{data}{A \code{data.frame} or \code{vector}.}

\item{replace}{If \code{data} is a \code{data.frame}, a named \code{list} giving the value to replace \code{NA} with for each column. If
\code{data} is a \code{vector}, a single value used for replacement.}

\item{...}{Additional arguments passed onto methods; not currently used.}
}
\value{
If \code{data} is a \code{data.frame}, \code{replace_na()} returns a \code{data.frame}. If \code{data} is a \code{vector}, \code{replace_na()} returns a
\code{vector} of class determined by the union of \code{data} and \code{replace}.
}
\description{
Replace missing values in a \code{data.frame} or \code{vector}.
}
\examples{
df <- data.frame(x = c(1, 2, NA), y = c("a", NA, "b"), stringsAsFactors = FALSE)
df \%>\% replace_na(list(x = 0, y = "unknown"))
df \%>\% mutate(x = replace_na(x, 0))

df$x \%>\% replace_na(0)
df$y \%>\% replace_na("unknown")

}
\seealso{
\code{\link[=na_if]{na_if()}} to replace specified values with a \code{NA}. \code{\link[=coalesce]{coalesce()}} to replace missing values within subsequent
\code{vector}(s) of value(s).
}
