% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalesce.R
\name{coalesce}
\alias{coalesce}
\title{Find first non-missing element}
\usage{
coalesce(...)
}
\arguments{
\item{...}{Vectors. Inputs should be recyclable (either be length \code{1L} or \code{n}) and coercible to a common type.}
}
\description{
Given a set of vectors, \code{coalesce()} finds the first non-missing value at each position. This is inspired by the SQL
\code{COALESCE} function which does the same thing for \code{NULL}s.
}
\details{
Currently, \code{coalesce()} type checking does not take place.
}
\examples{
# Use a single value to replace all missing vectors
x <- sample(c(1:5, NA, NA, NA))
coalesce(x, 0L)

# Or match together a complete vector from missing pieces
y <- c(1, 2, NA, NA, 5)
z <- c(NA, NA, 3, 4, 5)
coalesce(y, z)

}
